<?php
/*
 * Copyright © 2018-2026 RBSoft (Ravi Patel). All rights reserved.
 *
 * Author: Ravi Patel
 * Website: https://rbsoft.org/downloads/sms-gateway
 *
 * This software is licensed, not sold. Buyers are granted a limited, non-transferable license
 * to use this software exclusively on a single domain, subdomain, or computer. Usage on
 * multiple domains, subdomains, or computers requires the purchase of additional licenses.
 *
 * Redistribution, resale, sublicensing, or sharing of the source code, in whole or in part,
 * is strictly prohibited. Modification (except for personal use by the licensee), reverse engineering,
 * or creating derivative works based on this software is strictly prohibited.
 *
 * Unauthorized use, reproduction, or distribution of this software may result in severe civil
 * and criminal penalties and will be prosecuted to the fullest extent of the law.
 *
 * For licensing inquiries or support, please visit https://support.rbsoft.org.
 */

if (count(get_included_files()) == 1) {
    http_response_code(403);
    die("HTTP Error 403 - Forbidden");
}

$timeout = 86400;
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../vendor/autoload.php";
date_default_timezone_set(TIMEZONE);
session_cache_limiter('nocache');
session_set_cookie_params([
    'lifetime' => $timeout,
    'path' => '/',
    'samesite' => 'Lax'
]);
$JWTSession = new ravibpatel\JWTSession\JWTSession($timeout, APP_SECRET_KEY, false, APP_SESSION_NAME);
$JWTSession->setSessionHandler(true);

require_once __DIR__ . "/initialize.php";
