<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Iam
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Iam\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;


class OAuthAppContext extends InstanceContext
    {
    /**
     * Initialize the OAuthAppContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid Unique ID (sid) of the OAuth app
     */
    public function __construct(
        Version $version,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'sid' =>
            $sid,
        ];

        $this->uri = '/Account/OAuthApps/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Delete the OAuthAppInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->delete('DELETE', $this->uri, [], [], $headers);
    }


    /**
     * Update the OAuthAppInstance
     *
     * @param IamV1AccountVendorOauthAppUpdateRequest $iamV1AccountVendorOauthAppUpdateRequest
     * @return OAuthAppInstance Updated OAuthAppInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(IamV1AccountVendorOauthAppUpdateRequest $iamV1AccountVendorOauthAppUpdateRequest): OAuthAppInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $iamV1AccountVendorOauthAppUpdateRequest->toArray();
        $payload = $this->version->update('PUT', $this->uri, [], $data, $headers);

        return new OAuthAppInstance(
            $this->version,
            $payload,
            $this->solution['sid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Iam.V1.OAuthAppContext ' . \implode(' ', $context) . ']';
    }
}
